#!/usr/bin/env python

"""

 $Id$

 sRecnik.py - pretraga englesko-srpskog recnika

 Copyright (c) 2003 Aleksandar Radulovic <alex@a13x.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details (included in gpl.txt).

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 Koriscenje:
 $ srecnik.py
	CLI mod (komandni interfejs)
 
 $ srecnik.py <trazena rec>
    pretraga srpskog recnika (tip srpsko-engleski)

 $ srecnik.py <trazena rec> <tip>
	pretraga recnika, tip se podesava u komandnoj liniji (en ili sr)

 Skript koristi sledece biblioteke koje morate imati instalirane:
	SQLite (http://www.sqlite.org)
	PySQLite (http://pysqlite.sourceforge.net)

"""
import sys

try:
	import sqlite
except ImportError, error:
	print error
	print "SQLite mora biti instaliran. Za detalje pogledajte README fajl."

""" konstante """
sqlbaza = "recnik.db"
s = sys.argv[0]
rec = ""
type = ""
cli = 0
SQL = ""

""" Funkcije """
def Upit(cursor, rec):
	cursor.execute(SQL, rec)
	if cursor.rowcount:
		print "Rezultat pretrage:"
		for row in cursor.fetchall():
			meaning = row.meaning.split('-')
			print "\n%s " % row.word
			for mrec in meaning:
				print "%s-> %s" % ((' ' * len(row.word)), mrec)
	else:
		print "Trazena rec nije u recniku!"

""" Provera argumenata """
if sys.argv[2:]:
	rec = sys.argv[1]
	type = sys.argv[2]
elif sys.argv[1:]:
	rec = sys.argv[1]
	type = 'sr'
else:
	cli = 1
	type = 'sr'

""" Provera tipa """
if type=='sr':
	SQL = "select word, meaning from sren where word like %s"
elif type=='en':
	SQL = "select word, meaning from ensr where word like %s"
else:
	print "Tip moze biti samo en (za engleski) ili sr (za srpski)"
	sys.exit()

""" Otvaranje baze """
try:
	conn = sqlite.connect(sqlbaza,mode=755)
	cursor = conn.cursor()
except:
	print "SQL konekcija nije uspela! Proverite lokaciju baze."
	sys.exit(1)

if not cli:
	""" Nije CLI mod, uradi upit """
	Upit(cursor, rec)
else:
	""" CLI mod """
	print "sRecnik.py CLI mod"
	print "\nUnesite trazenu rec ili .help za pomoc"
	while 1:
		command = raw_input('>>> ')
		if command[0:1] == '.':
			space = command.find(' ')
			if space < 1:
				space = len(command)+1
			""" komande su u pitanju """
			if command[1:space]=='help':
				print "sRecnik.py CLI pomoc:"
				print ".help - pomoc"
				print ".type <tip> - tip recnika (sr ili en)"
				print ".quit - izlaz"
			elif command[1:space] == 'type':
				if command.find(' ') > 0:
					(cmd, type) = command.split(' ')
					if type=='sr':
						SQL = "select word, meaning from sren where word like %s"
						print "Pretraga srpsko-engleskog recnika"
					elif type=='en':
						SQL = "select word, meaning from ensr where word like %s"
						print "Pretraga englesko-srpskog recnika"
				else:
					print "Tip moze biti samo en (za engleski) ili sr (za srpski)"
					print "Trenutno podesen: %s" % type
			elif command[1:space] =='quit':
				print "Kraj programa"
				break
		else:
			""" trazi se rec """
			Upit(cursor, command)
""" Zatvaramo bazu """
conn.close()